﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Controller : MonoBehaviour
{
    //va servir à la manipulation des propriétés du perso
    private Rigidbody2D rb2d;
    private float moveInput;
    private float speed = 10f;

    //lancer le jeu quand le joueur tappe sur Espace
    private bool isStarted = false;

    //gère le score
    private float topScore = 0.0f;

    //permet l'affichage du score et du texte "space to start"
    public Text scoreText;
    public Text startText;

    //voir si le perso posède le chapeau
    public GameObject HatPlayerPlayer;


    // Start is called before the first frame update
    void Start()
    {
	//on ajoute au perso un rigidbody pour rentrer en contact avec les plateformes.
        rb2d = GetComponent<Rigidbody2D>();

	//on maintient le perso en l'air
        rb2d.gravityScale = 0;
        rb2d.velocity = Vector3.zero;

	//le score n'est pas affiché
	scoreText.gameObject.SetActive(false);

    }

     void Update()
    {
	//si le joueur appuis sur Espace au début du jeu
        if(Input.GetKeyDown(KeyCode.Space) && isStarted == false)
        {

            isStarted = true;

	    //on enlève Space to Start
            startText.gameObject.SetActive(false);

	    //on remet de la gravité pour que le perso tombe sur la première plateforme;
            rb2d.gravityScale = 5f;

	    //on affiche le score en cours de partie
	    scoreText.gameObject.SetActive(true);

        }

        if (isStarted == true)
        {

	    //si le joueur va à droite, on flip l'image du perso, sinon l'image reste tel quel. 
            if (moveInput < 0)
            {

                this.GetComponent<SpriteRenderer>().flipX = false;

            }
            else
            {

                this.GetComponent<SpriteRenderer>().flipX = true;

            }

	    //si le perso va vers le haut, il gagne des points mais il doit aller plus haut qu'il n'a déjà été (position.y doit être supérieur à son score).

            if (rb2d.velocity.y > 0 && transform.position.y > topScore)
            {

                topScore = transform.position.y;
		
		if(HatPlayerPlayer.activeSelf){
	            //topScore +=200; 
		}

            }
	    //on affiche le score sur l'interface du jeu
            scoreText.text = "Score : " + Mathf.Round(topScore).ToString();
        }

    }

    void FixedUpdate()
    {

        if (isStarted == true)
        {
	    //définition du jeu sur les axes gauches et droites (-1 et 1)
            moveInput = Input.GetAxis("Horizontal");

	    //on fait bouger le perso
            rb2d.velocity = new Vector2(moveInput * speed, rb2d.velocity.y);

        }

    }

}
